/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.VanillaPlugin;

public class NoteBlockProvider
implements IComponentProvider {
    public static final NoteBlockProvider INSTANCE = new NoteBlockProvider();
    private static final String[] PITCH = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};
    private static final ChatFormatting[] OCTAVE = new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.YELLOW, ChatFormatting.GOLD};

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(VanillaPlugin.NOTE_BLOCK)) {
            return;
        }
        BlockState state = accessor.getBlockState();
        int note = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
        String pitch = PITCH[note % PITCH.length];
        ChatFormatting octave = OCTAVE[note / PITCH.length];
        NoteBlockInstrument instrument = (NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_);
        tooltip.add((Component)new TranslatableComponent("%s %s", new Object[]{new TranslatableComponent("jade.instrument." + instrument.m_7912_()), octave + pitch}));
    }
}

